<!--
User code ~ Name ~ Table ~ count ~ Completed ~ Fresh ~ Stopped etc
956 ~ milis ~ msekobp2017 ~ 30 ~ 20% ~ 75% ~ 5%
-->
<?php
$DATABASE_NAME = 'A11898_ON';
//print_r( $DataCounts );
//$TablesForSearching = ['MSEKOBP_2016', 'MSEKOBP_2017', 'MS_OPAPP', 'MS_OPAP2017'];//testing
$TablesForSearching = [];
$this->db->order_by('TABLE_NAME');
$TablesThatAreOn = $this->db->get_where('allowed_tables', array('DATABASE_NAME'=>$DATABASE_NAME));
foreach($TablesThatAreOn->result() AS $tb)
	$TablesForSearching[] = $tb->TABLE_NAME;

if(!isset($AllUsers))
{
	$this->db->order_by('username');
	$AllUsers = $this->db->get_where('users', array('type'=>USER_TYPE_GUEST));
}

/*
COMPLETED
STOPPED
FRESH
TIMED_OUT
FAILED
*/
?>
<section>
	<div class="section-body">
		<div class="container" style="<?php if($this->muser->data()->type==USER_TYPE_GUEST)echo 'max-width: 850px;'; ?>">
			<div class="row">
				<div class="col-lg-12">
					<table class="table table-condensed table-hover no-margin editor table-results">
						<thead>
							<tr>
								<th>#</th>
								<?php if(in_array($this->muser->data()->type, [USER_TYPE_ADMIN, USER_TYPE_OFFICE])){ ?>
								<th>User Code</th>
								<th>Name</th>
								<?php } ?>
								<th>Table</th>
								<th>Count</th>
								<th>
									Completed
								</th>
								<th>
									Stopped
								</th>
								<th>
									Fresh
								</th>
								<th>
									Timed Out
								</th>
								<th>
									Failed
								</th>
							</tr>
							<tr>
								<th></th>
								<?php if(in_array($this->muser->data()->type, [USER_TYPE_ADMIN, USER_TYPE_OFFICE])){ ?>
								<th>
									<input type="text" class="form-control" id="filter-user-code" onkeyup="FoFilterTheTable();">
								</th>
								<th>
									<input type="text" class="form-control" id="filter-user-name" onkeyup="FoFilterTheTable();">
								</th>
								<?php } ?>
								<th>
									<input type="text" class="form-control" id="filter-table" onkeyup="FoFilterTheTable();">
								</th>
								<th class="count"></th>
								<th class="count completed">
									
								</th>
								<th class="count stopped">
									
								</th>
								<th class="count fresh">
									
								</th>
								<th class="count timed-out">
									
								</th>
								<th class="count failed">
									
								</th>
							</tr>
						</thead>
						<tbody>
							<?php 
							$Index=1; 
							$TotalCounts = array(
														'total'=>0,
														'completed'=>0,
														'stopped'=>0,
														'fresh'=>0,
														'timed_out'=>0,
														'failed'=>0,
													);
							foreach($AllUsers->result() AS $user)
								//if($user->fieldwork!='')
							{ 
								$FieldWorkValue=urlencode($user->fieldwork);
							?>
								<?php
								for($itb=0;$itb<count($TablesForSearching);$itb++)
								{
									$TABLE_NAME = $TablesForSearching[$itb];
									$FieldWorkColumnName = $this->db->get_where('fieldwork_reference', array('DATABASE_NAME'=>$DATABASE_NAME, 'TABLE_NAME'=>$TABLE_NAME))->row();
									if($FieldWorkColumnName!=NULL)
										$FieldWorkColumnName = $FieldWorkColumnName->fieldName;
									else
										$FieldWorkColumnName = '';
									$UrlForLoadingData = "http://e-globallink.gr/surveys/loading-sources/LoadTotalUserTasks.php?TABLE_NAME=$TABLE_NAME&FieldWorkColumnName=$FieldWorkColumnName&FieldWorkValue=$FieldWorkValue";
									if( $FieldWorkColumnName!='' && $FieldWorkValue!='' )
									{
										$DataStringJSON = file_get_contents( $UrlForLoadingData );
										$GValues = json_decode( $DataStringJSON );
										$URLForTotal = base_url("mssqlapp/ViewTableData/$DATABASE_NAME/$TABLE_NAME/$FieldWorkColumnName/".$user->fieldwork);
										//$GValues = $DataCounts->grouping[$itb]; 
										if($GValues->count_total>0){
										?>
										<tr fieldwork="<?php echo $user->fieldwork; ?>" username="<?php echo $user->username; ?>" table="<?php echo $TABLE_NAME; ?>">
											<td><?php echo $Index++; //echo $UrlForLoadingData; ?></td>
											<?php if(in_array($this->muser->data()->type, [USER_TYPE_ADMIN, USER_TYPE_OFFICE])){ ?>
											<td><?php echo $user->fieldwork; ?></td>
											<td><?php echo $user->username; ?></td>
											<?php } ?>
											<td><a href="<?php echo $URLForTotal.'/no'; ?>" target="_blank"><?php echo $TABLE_NAME; ?> <i class="fa fa-th" aria-hidden="true"></i></a></td>

											<?php if(isset($GValues->error)){ ?>
											<td colspan="6">
												<?php echo $GValues->message; ?>
											</td>
											<?php }else{ 
												$TotalCounts['total']+=$GValues->count_total;
												$TotalCounts['completed']+=$GValues->count_completed;
												$TotalCounts['stopped']+=$GValues->count_stopped;
												$TotalCounts['fresh']+=$GValues->count_fresh;
												$TotalCounts['timed_out']+=$GValues->count_TimedOut;
												$TotalCounts['failed']+=$GValues->count_failed;
												?>
											<td>
												<a href="<?php echo $URLForTotal.'/no'; ?>" target="_blank">
													<span class="count" for="total"><?php echo $GValues->count_total; ?></span>
												</a>
											</td>
											<td>
												<a href="<?php echo $URLForTotal.'/COMPLETED'; ?>" target="_blank">
													<?php echo number_format(($GValues->count_completed/($GValues->count_total==0?1:$GValues->count_total))*100, 2); ?>%
													<br>n=<span class="count" for="COMPLETED"><?php echo number_format($GValues->count_completed, 0, '', ''); ?></span>
												</a>
											</td>
											<td>
												<a href="<?php echo $URLForTotal.'/STOPPED'; ?>" target="_blank">
													<?php echo number_format(($GValues->count_stopped/($GValues->count_total==0?1:$GValues->count_total))*100, 2); ?>%
													<br>n=<span class="count" for="STOPPED"><?php echo number_format($GValues->count_stopped, 0, '', ''); ?></span>
												</a>
											</td>
											<td>
												<a href="<?php echo $URLForTotal.'/FRESH'; ?>" target="_blank">
													<?php echo number_format(($GValues->count_fresh/($GValues->count_total==0?1:$GValues->count_total))*100, 2); ?>%
													<br>n=<span class="count" for="FRESH"><?php echo number_format($GValues->count_fresh, 0, '', ''); ?></span>
												</a>
											</td>
											<td>
												<a href="<?php echo $URLForTotal.'/TIMED_OUT'; ?>" target="_blank">
													<?php echo number_format(($GValues->count_TimedOut/($GValues->count_total==0?1:$GValues->count_total))*100, 2); ?>%
													<br>n=<span class="count" for="TIMED_OUT"><?php echo number_format($GValues->count_TimedOut, 0, '', ''); ?></span>
												</a>
											</td>
											<td>
												<a href="<?php echo $URLForTotal.'/FAILED'; ?>" target="_blank">
													<?php echo number_format(($GValues->count_failed/($GValues->count_total==0?1:$GValues->count_total))*100, 2); ?>%
													<br>n=<span class="count" for="FAILED"><?php echo number_format($GValues->count_failed, 0, '', ''); ?></span>
												</a>
											</td>
											<?php } ?>

										</tr>

							<?php }}
								}
								//if($Index==4)break;//testing
								//print_r( $TotalCounts );//testing
							} ?>
						</tbody>
					</table>
				</div>
			</div>
	</div>
</section>

<script type="text/javascript">
function FoFilterTheTable()
{
	//<tr fieldwork="<?php echo $user->fieldwork; ?>" username="<?php echo $user->username; ?>" table="<?php echo $TABLE_NAME; ?>">
	var filters = {
		fv:$('input#filter-user-code').length==0?'':$('input#filter-user-code').val().toLowerCase(),
		un:$('input#filter-user-name').length==0?'':$('input#filter-user-name').val().toLowerCase(),
		ft:$('input#filter-table').length==0?'':$('input#filter-table').val().toLowerCase()
	};
	/*if(filters.fv=='' && filters.un=='' && filters.ft=='')
	{
		$('table.table-results tbody tr').css('display', 'default');
		return;
	}*/
	//console.log('filters:', filters);
	$('table.table-results tbody tr').css('display', 'none');
	$('table.table-results tbody tr').each(function(index){
		//console.log($(this).attr('fieldwork').indexOf(filters.fv), $(this).attr('username').indexOf(filters.un), $(this).attr('table').indexOf(filters.ft));
		if($(this).attr('fieldwork').toLowerCase().indexOf(filters.fv)!=-1 
			&& $(this).attr('username').toLowerCase().indexOf(filters.un)!=-1 
			&& $(this).attr('table').toLowerCase().indexOf(filters.ft)!=-1)
			$(this).css('display', 'default');
	});

	TotalCounts = {total:0, completed:0, stopped:0, fresh:0, timed_out:0, failed:0};
	$('table.table-results tbody tr').each(function(index){
		if($(this).css('display')!='none')
		{
			TotalCounts.total += parseInt( $(this).find('span.count[for="total"]').html() );
			TotalCounts.completed += parseInt( $(this).find('span.count[for="COMPLETED"]').html() );
			TotalCounts.stopped += parseInt( $(this).find('span.count[for="STOPPED"]').html() );
			TotalCounts.fresh += parseInt( $(this).find('span.count[for="FRESH"]').html() );
			TotalCounts.timed_out += parseInt( $(this).find('span.count[for="TIMED_OUT"]').html() );
			TotalCounts.failed += parseInt( $(this).find('span.count[for="FAILED"]').html() );
		}
	});


	$('th.count').html(TotalCounts.total);
	$('th.count.completed').html(TotalCounts.completed);
	$('th.count.stopped').html(TotalCounts.stopped);
	$('th.count.fresh').html(TotalCounts.fresh);
	$('th.count.timed-out').html(TotalCounts.timed_out);
	$('th.count.failed').html(TotalCounts.failed);

}
/*Array ( [total] => 111 [completed] => 5 [stopped] => 8 [fresh] => 98 [timed_out] => 0 [failed] => 0 ) Array ( [total] => 116 [completed] => 5 [stopped] => 8 [fresh] => 103 [timed_out] => 0 [failed] => 0 )*/
var TotalCounts = <?php echo json_encode($TotalCounts); ?>;
window.addEventListener('load', function(){
	$('th.count').html(TotalCounts.total);
	$('th.count.completed').html(TotalCounts.completed);
	$('th.count.stopped').html(TotalCounts.stopped);
	$('th.count.fresh').html(TotalCounts.fresh);
	$('th.count.timed-out').html(TotalCounts.timed_out);
	$('th.count.failed').html(TotalCounts.failed);
});
</script>

